import { ControlPropsBase, ControlStateBase, toOneWayRef } from '@ibiz-core';

/**
 * 部件基类
 */
export class ControlBase {
  /**
   * 部件状态
   */
  public controlState: ControlStateBase;

  /**
   * 构造方法，初始化状态
   * @param {*} options 配置参数
   */
  constructor(options: any) {
    this.controlState = reactive(options);
  }

  /**
   * 根据props调整设置部分部件基类
   * @param props 传入的Props
   */
  public setState(props: ControlPropsBase) {
    // toDo 项目级配置入口，优先级大于平台，提供全局的一次性配置
    
    // 只读属性处理：把props的属性的Ref赋给state，以维持响应性。
    this.controlState.viewSubject = toRef(props, 'viewSubject') as any;
  }

  /**
   * 使用部件上下文参数逻辑块
   * @param props 传入的Props
   */
  public useControlContextParams(props: ControlPropsBase) {
    const context = toOneWayRef(props, 'context');
    const viewParams = toOneWayRef(props, 'viewParams');

    // 把Ref赋值到State上进行解包
    this.controlState.context = context;
    this.controlState.viewParams = viewParams;

    return { context, viewParams };
  }

  /**
   * 安装部件所有功能模块的方法
   * @param props 传入的Props
   * @param [emit] 事件
   */
  public moduleInstall(props: ControlPropsBase, emit?: Function) {
    this.setState(props);
    this.useControlContextParams(props);
    return {
      state: this.controlState,
    };
  }
}
